<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: *');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    if (empty($_FILES['chunk'])) {
        throw new Exception('No chunk received');
    }

    $uploadId = $_POST['uploadId'] ?? 'default';
    $chunkIndex = $_POST['index'] ?? 0;
    $path = $_POST['path'] ?? 'edge/' . date('Y-m');
    
    // Sanitize path
    $path = 'files/' . trim($path, '/');
    $path = preg_replace('/\.\./', '', $path);
    
    // Create chunk directory
    $chunkDir = "{$path}/chunks/{$uploadId}";
    if (!is_dir($chunkDir)) {
        mkdir($chunkDir, 0777, true);
    }
    
    // Save chunk
    $chunkPath = "{$chunkDir}/{$chunkIndex}.chunk";
    if (!move_uploaded_file($_FILES['chunk']['tmp_name'], $chunkPath)) {
        throw new Exception('Failed to save chunk');
    }
    
    echo 'OK';
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'Error: ' . $e->getMessage();
}
?>