<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['uploadId']) || !isset($input['fileName'])) {
        http_response_code(400);
        exit('Missing uploadId or fileName');
    }
    
    $uploadId = $input['uploadId'];
    $path = $input['path'] ?? 'edge/' . date('Y-m');
    $fileName = basename($input['fileName']); // Sanitize filename
    
    // Sanitize paths
    $path = 'files/' . trim($path, '/');
    $path = preg_replace('/\.\./', '', $path);
    
    $chunkDir = "chunks/{$path}/{$uploadId}";
    $finalDir = $path;
    
    if (!is_dir($chunkDir)) {
        throw new Exception('Upload session not found');
    }
    
    // Create final directory
    if (!is_dir($finalDir)) {
        mkdir($finalDir, 0777, true);
    }
    
    // Get all chunks and sort by index
    $chunks = glob("{$chunkDir}/*.chunk");
    if (empty($chunks)) {
        throw new Exception('No chunks found');
    }
    
    // Sort chunks numerically by their index
    usort($chunks, function($a, $b) {
        $aIndex = intval(basename($a, '.chunk'));
        $bIndex = intval(basename($b, '.chunk'));
        return $aIndex - $bIndex;
    });
    
    // Assemble file
    $finalPath = "{$finalDir}/{$fileName}";
    $finalHandle = fopen($finalPath, 'wb');
    
    if (!$finalHandle) {
        throw new Exception('Failed to create final file');
    }
    
    foreach ($chunks as $chunkPath) {
        $chunkData = file_get_contents($chunkPath);
        fwrite($finalHandle, $chunkData);
        unlink($chunkPath); // Clean up chunk
    }
    
    fclose($finalHandle);
    
    // Clean up empty chunk directory
    if (is_dir($chunkDir)) {
        rmdir($chunkDir);
    }
    
    //echo 'https://w.kunok.com/' . $finalPath;
    // TO THIS:
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
echo "{$protocol}://{$host}/" . $finalPath;
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'Error: ' . $e->getMessage();
    error_log("Assembly error: " . $e->getMessage());
}
?>