<?php
/*  edgeup.php  – single-shot upload, same folders, CORS enabled  */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: text/plain; charset=utf-8');

/* pre-flight OPTIONS request – stop here */
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

/* basic sanity */
if (!isset($_FILES['file']['tmp_name'])) {
    http_response_code(400);
    exit('No file received');
}

$tmp  = $_FILES['file']['tmp_name'];
$name = basename($_FILES['file']['name']);
$pathorg = isset($_POST['path']) && $_POST['path']
        ? 'files/'.trim($_POST['path'], '/')
        : 'files/edge/'.date('Y-m');  
$path = isset($_POST['path']) && $_POST['path']
        ? 'files/'.trim($_POST['path'], '/')
        : 'files';  // ← DEFAULT TO ROOT FILES FOLDER

@mkdir($path, 0777, true);
$dest = $path.'/'.$name;

/* resolve name collision (optional) */
if (file_exists($dest)) {
    $ext  = pathinfo($name, PATHINFO_EXTENSION);
    $base = pathinfo($name, PATHINFO_FILENAME);
    $counter = 1;
    do {
        $dest = $path.'/'.$base.'_'.$counter++.($ext ? '.'.$ext : '');
    } while (file_exists($dest));
}

/* atomic move */
if (!move_uploaded_file($tmp, $dest)) {
    http_response_code(500);
    exit('Move failed');
}

/* FIXED: Use dynamic server URL instead of hardcoded */
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
echo "{$protocol}://{$host}/{$dest}";
?>