<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, HEAD, OPTIONS');
header('Access-Control-Allow-Headers: *');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$file = $_GET['file'] ?? '';
// Security: prevent directory traversal
$file = str_replace(['..', '../', '\\'], '', $file);
$path = __DIR__ . '/files/' . $file;

if (!file_exists($path) || !is_file($path)) {
    http_response_code(404);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'File not found']);
    exit;
}

$size = filesize($path);
$start = 0;
$end = $size - 1;
$length = $size;

// Handle range requests for resumable downloads
if (isset($_SERVER['HTTP_RANGE'])) {
    if (preg_match('/bytes=(\d*)-(\d*)/', $_SERVER['HTTP_RANGE'], $matches)) {
        $start = $matches[1] !== '' ? intval($matches[1]) : $start;
        $end = $matches[2] !== '' ? intval($matches[2]) : $end;
        
        // Ensure valid range
        if ($start > $end || $start >= $size || $end >= $size) {
            http_response_code(416); // Range Not Satisfiable
            header("Content-Range: bytes */$size");
            exit;
        }
        
        $length = $end - $start + 1;
        http_response_code(206); // Partial Content
    }
} else {
    http_response_code(200); // OK
}

// Get file info for download
$filename = basename($path);
$mime_type = mime_content_type($path) ?: 'application/octet-stream';

// Set headers
header("Content-Type: $mime_type");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Accept-Ranges: bytes");
header("Content-Length: $length");
if (isset($_SERVER['HTTP_RANGE'])) {
    header("Content-Range: bytes $start-$end/$size");
}

// Stream the file
$buffer_size = 8192; // 8KB chunks
$fp = fopen($path, 'rb');

if ($fp) {
    fseek($fp, $start);
    
    while (!feof($fp) && ($pos = ftell($fp)) <= $end) {
        if (connection_aborted()) break;
        
        $bytes_to_read = min($buffer_size, $end - $pos + 1);
        echo fread($fp, $bytes_to_read);
        flush();
    }
    
    fclose($fp);
}
?>